<?php

if (!function_exists("mb_chr")) {
   function mb_chr($ord, $encoding = "UTF-8")
   {
      if ($encoding === "UCS-4BE") {
         return pack("N", $ord);
      } else {
         return mb_convert_encoding(mb_chr($ord, "UCS-4BE"), $encoding, "UCS-4BE");
      }
   }
}
function ConvertNative2UTF($str_in)
{
   $str_w = mb_convert_encoding($str_in, "Windows-1251", "UTF-8");
   $len = strlen($str_w);
   $arr = [];

   //    for ($i=0;$i<$len;$i++) $str[$i] = ($str_w[$i]<128)?$str_w[$i]:(128+$str_w[$i]&0x7f);
   for ($i = 0; $i < $len; $i++) {
      $k = ord($str_w[$i]);
      //	echo $k." ";

      if ($k > 128) {
         if ($k == 208) {
            $k = 0x2116;
         } else {
            $k = 0x400 + ($k - 128);
         }
      }

      //	$str[$i] = ?$str_w[$i]:($str_w[$i]+48);
      array_push($arr, mb_chr($k, "UTF-8"));
   }
   $str = implode($arr);
   //echo "ConvertString: ".$str;//.mb_convert_encoding($str, "UTF-8", "Windows-1251");
   //echo "ConvertString: ".mb_convert_encoding($str, "UTF-8", "Windows-1251");
   //echo "<br>";
   return $str;
}

function ConvertUTF2Native_win1251($str_in)
{
   $len = mb_strlen($str_in, "UTF-8");
   $arr = [];

   //    for ($i=0;$i<$len;$i++) $str[$i] = ($str_w[$i]<128)?$str_w[$i]:(128+$str_w[$i]&0x7f);
   for ($i = 0; $i < $len; $i++) {
      $in_char = mb_substr($str_in, $i, 1, "UTF-8");
      $u = mb_convert_encoding($in_char, "UCS-2LE", "UTF-8");
      #echo $in_char." ";
      $k1 = ord(substr($u, 0, 1));
      $k2 = ord(substr($u, 1, 1));
      //echo $k1." ".$k2.";";

      if ($k2 > 0) {
         if ($k2 == 33 && $k1 == 22) {
            $k = 208;
         } else {
            $k = 128 + ($k1 & 0x7f);
         }
      } else {
         $k = $k1;
      }
      //	$str[$i] = ?$str_w[$i]:($str_w[$i]+48);
      array_push($arr, chr($k));
   }
   $str_w = implode($arr);
   return $str_w;
}

function ConvertUTF2Native($str_in)
{
   $str_w = ConvertUTF2Native_win1251($str_in);
   $str = mb_convert_encoding($str_w, "UTF-8", "Windows-1251");
   return $str;
}

function VersionConvert2IntArray($ver, bool $isFirst)
{
   $default = 0;
   if (!$isFirst) {
      $default = 255;
   }
   $verint = [0, 0, 0, 0];
   for ($i = 0; $i < 4; $i++) {
      if (isset($ver[$i])) {
         $verint[$i] = (int) $ver[$i];
      } else {
         $verint[$i] = $default;
      }
   }
   return $verint;
}

function array_sort_by_index($array)
{
   //echo "Array sort by id<br>";
   $new_array = [];
   $sortable_array = [];

   if (count($array) > 0) {
      foreach ($array as $k => $v) {
         $sortable_array[$k] = $v->index;
      }
      asort($sortable_array); //, SORT_NUMERIC);
      //echo "Array sort by id dump:<br>";
      //var_dump($sortable_array);echo "<br>";
      foreach ($sortable_array as $k => $v) {
         $new_array[$k] = $array[$k];
      }
   }

   return $new_array;
}

define("CHECK_READ", 1);
define("CHECK_WRITE", 2);
define("CHECK_PLAY", 4);
define("CHECK_PTZ", 8);

function accessServerCheck($mask)
{
   global $UserAccessServerMask;
   $result = false;
   if (isset($UserAccessServerMask[0]) && ($UserAccessServerMask[0] & $mask) > 0) {
      $result = true;
   }
   #    echo "ServerCheck ".$UserAccessServerMask[0]." ".$mask;
   return $result;
}

function accessCamCheck($camindex, $mask)
{
   global $UserAccessCamMask;
   $result = false;
   if (isset($UserAccessCamMask[$camindex]) && ($UserAccessCamMask[$camindex] & $mask) > 0) {
      $result = true;
   }
   return $result;
}
